//Senior Design Project - Austin Riffle
/***************************************************************************************/
/*****                                 INCLUDES                                    *****/
/***************************************************************************************/
#include <stdint.h>
#include <stdbool.h>
#include "inc/tm4c123gh6pm.h"
#include "inc/hw_memmap.h"
#include "driverlib/pin_map.h"
#include "driverlib/gpio.h"
#include "driverlib/sysctl.h"
#include "driverlib/adc.h"
#include "LharpPinMap.h"
#include "LharpMidiDefs.h"
#include "MidiInterface.h"
#include "UartInterface.h"
#include "globalDefs.h"

using midi::MidiInterface;
/***************************************************************************************/
/*****                                 DEFINITIONS                                 *****/
/***************************************************************************************/

//ADC Definitions
#define ADC0_SEQ_NUMBER							0//FIFO Depth of 8
#define ADC0_PRIORITY_LEVEL						0
#define ADC0_OVERSAMPLE_RATE					64//Must be exponent of two, no more then 64
//12 Bits divided by 2 -> 3.0/2 (V) = 1.5 (V)
#define ADC0_THRESHOLD							(0x01FF)
#define LDR_THRESHOLD							100//TODO: Calculate this

/***************************************************************************************/
/*****                                 ENUMS                                       *****/
/***************************************************************************************/

enum SensorType
{
	RangeSensors,
	LightDependentResistors
};

/***************************************************************************************/
/*****                                 PROTOTYPES                                  *****/
/***************************************************************************************/

static void setLEDs(void);
static void initADC(void);
static void initLED_GPIO(void);
static ADCData readADC(SensorType sensorType);
static ADCData readRangeSensors(void);
static ADCData readLDRs(void);
static void setMUXPosition(uint8_t inputPosition, SensorType sensorType);
static uint16_t getMidiPitchBend(void);

/***************************************************************************************/
/*****                                 FUNCTIONS                                   *****/
/***************************************************************************************/

int main(void)
{
	//set the clock source
	SysCtlClockSet(SYSCTL_SYSDIV_1 | SYSCTL_USE_PLL | SYSCTL_OSC_MAIN | SYSCTL_XTAL_16MHZ);

    //initialize peripherals
	initADC();
	initLED_GPIO();

	//initialize MIDI
	MidiInterface midi;
	midi.turnThruOff();
	midi.begin();

	uint16_t pitchBend;
	uint16_t muxLine = 0;

	while (1)
	{
		//Temporarily trying this to debug.
		GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_2, GPIO_PIN_2);
    	SysCtlDelay(SysCtlClockGet() / (10 * 3));

		GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_2, 0);
    	SysCtlDelay(SysCtlClockGet() / (10 * 3));


    	//Below code still in development
//		//Set the MUX position for the LDR's
//		setMUXPosition(muxLine, LightDependentResistors);
//
//		//Read Data from LDR's, generate MIDI data if appropriate
//		if (readADC(LightDependentResistors) > LDR_THRESHOLD)
//		{
//			midi.sendNoteOn(CMajorMidiScale[muxLine],
//							MIDI_DEFAULT_ON_VELOCITY,
//							MIDI_DEFAULT_CHANNEL);
//			//determine pitch bend
//			setMUXPosition(muxLine, RangeSensors);
//			pitchBend = getMidiPitchBend();
//			midi.sendPitchBend(pitchBend, MIDI_DEFAULT_CHANNEL);
//		}
//		else
//		{
//			midi.sendNoteOff(CMajorMidiScale[muxLine],
//							 MIDI_DEFAULT_OFF_VELOCITY,
//							 MIDI_DEFAULT_CHANNEL);
//
//		}
//		setLEDs();
//
//		//increment muxLine
//		muxLine = ++(muxLine) % NUM_OF_ADC_PINS;
	}
}

/***************************************************************************************/

void initADC(void)
{
	//TODO: Change for MUX's.
	//Use ifdefs to differentiate between EVAL Board and Design Board
	//Need to keep both in case Design Board issues prevent use

	//Enable the ADC Peripheral and related ports
	SysCtlPeripheralEnable(SYSCTL_PERIPH_ADC0);
	SysCtlDelay(3);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
	SysCtlDelay(3);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);
	SysCtlDelay(3);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);
	SysCtlDelay(3);

	//Set ADC PINS
	int i=0;
	for (i=0; i<NUM_OF_ADC_PINS; ++i)
	{
		GPIOPinTypeADC(adcToLedLUT.adcLUT[i].reg, adcToLedLUT.adcLUT[i].pin);
		SysCtlDelay(3);
	}

	//Set ADC to average samples in hardware before returning the value
	ADCHardwareOversampleConfigure(ADC0_BASE, ADC0_OVERSAMPLE_RATE);
	SysCtlDelay(3);

	//Turn off ADC sequence before configuring
	ADCSequenceDisable(ADC0_BASE, ADC0_SEQ_NUMBER);
	SysCtlDelay(3);

	//Configure the ADC - Sequence 0 -> 8 steps
	ADCSequenceConfigure(ADC0_BASE, ADC0_SEQ_NUMBER, ADC_TRIGGER_PROCESSOR, ADC0_PRIORITY_LEVEL);
	ADCSequenceStepConfigure(ADC0_BASE, ADC0_SEQ_NUMBER, 0, ADC_CTL_CH1);//CONTROLS LED 0
	ADCSequenceStepConfigure(ADC0_BASE, ADC0_SEQ_NUMBER, 1, ADC_CTL_CH2);//CONTROLS LED 1
	ADCSequenceStepConfigure(ADC0_BASE, ADC0_SEQ_NUMBER, 2, ADC_CTL_CH4);//CONTROLS LED 2
	ADCSequenceStepConfigure(ADC0_BASE, ADC0_SEQ_NUMBER, 3, ADC_CTL_CH5);//CONTROLS LED 3
	ADCSequenceStepConfigure(ADC0_BASE, ADC0_SEQ_NUMBER, 4, ADC_CTL_CH6);//CONTROLS LED 4
	ADCSequenceStepConfigure(ADC0_BASE, ADC0_SEQ_NUMBER, 5, ADC_CTL_CH7);//CONTROLS LED 5
	ADCSequenceStepConfigure(ADC0_BASE, ADC0_SEQ_NUMBER, 6, ADC_CTL_CH8);//CONTROLS LED 6
	ADCSequenceStepConfigure(ADC0_BASE, ADC0_SEQ_NUMBER, 7, ADC_CTL_CH11 |
															ADC_CTL_IE |
															ADC_CTL_END);//CONTROLS LED 7

	//Enable the sequence and clear the interrupt flag
	ADCSequenceEnable(ADC0_BASE, ADC0_SEQ_NUMBER);
	ADCIntClear(ADC0_BASE, ADC0_SEQ_NUMBER);
}

/***************************************************************************************/
// Inits GPIO pins, possibly used for things such as LEDs/flashy things we need to add later
void initLED_GPIO(void)
{
	//Enbale GPIO ports used for LEDs and set as outputs
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
	SysCtlDelay(3);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOC);
	SysCtlDelay(3);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);
	SysCtlDelay(3);

	int i = 0;
	for (i=0; i < NUM_OF_LEDS; ++i)
	{
		GPIOPinTypeGPIOOutput(adcToLedLUT.ledLUT[i].reg, adcToLedLUT.ledLUT[i].pin);
		SysCtlDelay(3);
	}
}

/***************************************************************************************/
//This function is temporary, essentially just for debugging
void setLEDs(void)
{
	int i;
	for (i=0; i < NUM_OF_LEDS; ++i)
	{
		//If above threshold, set the pin, else clear it
		if (adcToLedLUT.adcValues[i] > ADC0_THRESHOLD)
		{
			GPIOPinWrite(adcToLedLUT.ledLUT[i].reg,
						 adcToLedLUT.ledLUT[i].pin,
						 adcToLedLUT.ledLUT[i].pin);
		}
		else
		{
			GPIOPinWrite(adcToLedLUT.ledLUT[i].reg,
						 adcToLedLUT.ledLUT[i].pin,
						 ~adcToLedLUT.ledLUT[i].pin);
		}
	}
	SysCtlDelay(3);
}

/***************************************************************************************/

ADCData readADC(SensorType sensorType)
{
	//TODO: Implement this
	ADCData ret;
	switch(sensorType)
	{
		case RangeSensors:
			break;

		case LightDependentResistors:
			break;

		default:
			break;
	}
	return ret;
}

/***************************************************************************************/

ADCData readRangeSensors(void)
{
	ADCData data;
	//TODO: Change for MUX's.
	//Trigger the interrupt
	ADCProcessorTrigger(ADC0_BASE, ADC0_SEQ_NUMBER);

	//Wait for the ADC to finish reading
	while(!ADCIntStatus(ADC0_BASE, ADC0_SEQ_NUMBER, false)) {}

	//Clear the flags
	ADCIntClear(ADC0_BASE, ADC0_SEQ_NUMBER);

	//write data to adcValues (FIFO)
	ADCSequenceDataGet(ADC0_BASE, ADC0_SEQ_NUMBER, &data);

	return data;
}

/***************************************************************************************/

ADCData readLDRs(void)
{
	ADCData data;
	//TODO: Change for MUX's.
	//Trigger the interrupt
	ADCProcessorTrigger(ADC0_BASE, ADC0_SEQ_NUMBER);

	//Wait for the ADC to finish reading
	while(!ADCIntStatus(ADC0_BASE, ADC0_SEQ_NUMBER, false)) {}

	//Clear the flags
	ADCIntClear(ADC0_BASE, ADC0_SEQ_NUMBER);

	//write data to adcValues (FIFO)
	ADCSequenceDataGet(ADC0_BASE, ADC0_SEQ_NUMBER, &data);

	return data;
}

/***************************************************************************************/

uint16_t getMidiPitchBend(void)
{
	uint16_t ret;
	ADCData data = readADC(RangeSensors);

	//todo: calculate ret

	return ret;
}

/***************************************************************************************/

void setMUXPosition(uint8_t lineNumber, SensorType sensorType)
{
	//TODO: Implement. Set 3 GPIO lines based on line number
	//to switch mux input to uC. Need to set MUX's for both
	//LDR's and Range Sensors
	switch(sensorType)
	{
		case RangeSensors:
			break;

		case LightDependentResistors:
			break;

		default:
			break;
	}
}

/***************************************************************************************/
